/* (C) Brendan Macmillan 2003
	Free for commercial use only
*/

/* Note:
	JSX deals in "events", such as the start of an array, the end of an array,
	a primitive int value and so on.  When writing, each event is represented
	by a method call.  When reading, the next event is obtained by calling
	"next()", which returns an int which represents the event (see DataReaderI).
	The details of this event can be obtained from various "get" methods,
	(also in DataReaderI).

	The grammar of these events is the same as the "native" XML grammar
	for JSX.  Thus, you can see examples of the grammar just by looking at
	XML fragments generated by JSX; and the documentation of the XML grammar
	also documents the events.
*/

package JSX;

import JSX.parser.*; //	Now use my version of "XmlPullParser"
import java.util.*;
import java.io.*;




public class DataReader implements DataReaderI {

		// TODO: interface XMLReaderI (could be an SQLReader etc)
  private XMLReader parser;


		// FIXME: send in the reader here.  Why not?
  public DataReader() throws IOException {
    parser = new XMLReader();
  }

  public void setReader(Reader reader) throws IOException {
		try {
    	parser.setInput(reader);
		} catch (XMLReaderException e) {
			e.printStackTrace();
			// FIXME: rethrow somehow, to percolate up
		}
  }


	public void close() throws IOException {
		parser.close();
	}

	public boolean ready() throws IOException {
		return parser.ready();
	}



// TODO: field accesses are easier and faster than getters.
//	Also easier for users to write.
//  We can write a test tool, to ensure correctness
// Nice if same style in ObjXML and XMLObj - but not possible


  public String id;
  public String getId() {
		return id;
  }

  public String className;
  public String getClassName() {
		return className;
  }

  public String superclasses;
  public String getSuperclasses() {
		return superclasses;
	}

  public String fieldName;
  public String getFieldName() {
		return fieldName;
  }

  public String value;
  public String getFieldValue() {
		return value;
  }

  public String primitiveType;
  public String getPrimitiveType() {
		return primitiveType;
  }


  public int arrayLength;	// just "length"?
  public int getArrayLength() {
		return arrayLength;
  }

	public int dim;
  public int getArrayDim() {
		return dim;
  }

	public String baseType;	// "base"?
  public String getArrayBase() {
		return baseType;
  }

  private String idref;	// "idref"
  public String getAliasRef() {
		return idref;
  }




/*																-----
																	debug
																	-----																			*/

/** return information about the position */
	public String getDebugInfo() {
		return " at line "+parser.getLine();	// line starts at 1
	}



/*																----
																	next
																	----																			*/

  public int next() throws IOException {
	
	 while (true) {	// TODO: test (only needed events with my parser)
    int xmlEvent = -1;
		try {
			xmlEvent = parser.next();
		} catch (XMLReaderException e) {
			e.printStackTrace();
				// FIXME: is this best?
			throw new IOException(e.toString());
		}
/*
		System.err.println(token[xmlEvent]);
		System.err.println(parser.getName());
		System.err.println(parser.attrs);
*/

    String name;
    String[] stackItem;

    switch (xmlEvent) {

      // START TAGS
      case XMLReader.START_TAG:
        name = parser.getName();

				// RESET
        if (name.equals("reset")) {
          return RESET;
				}

        // COLLECTION
					//FIXME: static final names (makes more confusing, I think)
        if (name.equals("collection")) {
          id = parser.getAttributeValue("", "id");
          fieldName = parser.getAttributeValue("", "field");
          className = parser.getAttributeValue("", "class");
         	return OPEN_COLLECTION;
        }

        // OBJECT
					//FIXME: static final names (makes more confusing, I think)
        if (name.equals("object")) {
          id = parser.getAttributeValue("", "id");
          fieldName = parser.getAttributeValue("", "field");
          className = parser.getAttributeValue("", "class");
          superclasses = parser.getAttributeValue("", "superclasses");
         	return OPEN_OBJECT;
        }

        // DECLARED CLASS
        else if (name.equals("declaredClass")) {
          className = parser.getAttributeValue("", "class");
          return OPEN_DECLARED_CLASS;
        }

        // PRIMITIVE
        else if (name.equals("primitive")) {
          fieldName = parser.getAttributeValue("", "field");
					primitiveType = parser.getAttributeValue("", "type");
          value = parser.getAttributeValue("", "value");
          return PRIMITIVE;
        }

        // STRING
        else if (name.equals("string")) {
          fieldName = parser.getAttributeValue("", "field");
          id = parser.getAttributeValue("", "id");	// NB: may be absent
          value = parser.getAttributeValue("", "value");
          return STRING;
        }

        // DEFAULT
        else if (name.equals("default")) {
          return OPEN_DEFAULT;
        }

        // ARRAY
        else if (name.equals("array")) { // # char: "array" vs "alias"
          fieldName = parser.getAttributeValue("", "field");
          id = parser.getAttributeValue("", "id");
          baseType = parser.getAttributeValue("", "base");	// was "class"
          String arrayDimStr = parser.getAttributeValue("", "dim");
          // if (arrayDimStr!=null)
						dim = Integer.parseInt(arrayDimStr);
          String arrayLengthStr = parser.getAttributeValue("", "length");
          // if (arrayLengthStr!=null)
          	arrayLength = Integer.parseInt(arrayLengthStr);
					// parseArrayHeader(className);	// fix it up for next level!
          return OPEN_ARRAY;
        }

        // NULL
        else if (name.equals("null")) {
          fieldName = parser.getAttributeValue("", "field");
          return NULL;
        }

        // CLASS (not declaredClass)
        else if (name.equals("class")) {
          fieldName = parser.getAttributeValue("", "field");
          className = parser.getAttributeValue("", "class");
          return CLASS;
        }

        // REFERENCE
        else if (name.equals("reference")) {
          fieldName = parser.getAttributeValue("", "field");
          idref = parser.getAttributeValue("", "idref");
          return REFERENCE;
        }
        break;




			// END TAGS
      case XMLReader.END_TAG:
        name = parser.getName();

        // COLLECTION
					// static name useful for exact form (eg: spelling/capitalization)
        if (name.equals("collection")) {
          return CLOSE_COLLECTION;
        }

        // OBJECT
        if (name.equals("object")) {
          return CLOSE_OBJECT;
        }

        // DECLARED CLASS
        else if (name.equals("declaredClass")) {
          return CLOSE_DECLARED_CLASS;
        }

        // DEFAULT
        else if (name.equals("default")) {
          return CLOSE_DEFAULT;
        }

        // ARRAY
        else if (name.equals("array")) {
          return CLOSE_ARRAY;
        }
        break;

				// CLOSE
      case XMLReader.END_DOCUMENT:
        return CLOSE_GRAPH;
    }

    // if no match, loop until the next one
   }
	} 

}
