/* (C) Brendan Macmillan 2003
	Free for commercial use only
*/

/* Note:
	JSX deals in "events", such as the start of an array, the end of an array,
	a primitive int value and so on.  When writing, each event is represented
	by a method call.  When reading, the next event is obtained by calling
	"next()", which returns an int which represents the event (see DataReaderI).
	The details of this event can be obtained from various "get" methods,
	(also in DataReaderI).

	The grammar of these events is the same as the "native" XML grammar
	for JSX.  Thus, you can see examples of the grammar just by looking at
	XML fragments generated by JSX; and the documentation of the XML grammar
	also documents the events.
*/

/** DataWriter.
	Converts Data events (from ObjectWriter) to XML events (for XMLWriter)
	Rewrite this for a different XML format (how easy for SOAP...? namespace?)
	Replace this with different output altogether for SQL interface...

	Does surrounding <jsx> and </jsx>
	**/




package JSX;	// same namespace as Reading side (TODO: own package?)
import JSX.writer.XMLWriter;	// same namespace as Reading side (TODO: own package?)
import JSX.writer.Attr;

import java.util.*;
import java.io.*;



public class DataWriter implements DataWriterI {

	public DataWriter(Writer wout) {	// cp from OEXW5
		this(new XMLWriter(wout));
	}

		// Can pass in configured XMLWriter
		// or, a different kind of writer altother (such as an SQLWriter)
		// TODO: an interface ;-) 	please - conveniently named!
	XMLWriter out;
	public DataWriter(XMLWriter out) {
		this.out = out;
	}

	public void flush() throws IOException {
		out.flush();
	}
	public void close() throws IOException {
		out.close();	// chain
	}


/* efficiency ideas: beware losing generality */
	// IDEA: we could of course make specific
	// methods, like openArrayXML(). This would be
	// maximum fast.  The general solution would be
	// available for others to use.
	// In fact, I can't see any real reason to have
	// separate DataWriter and XMLWriter - on the
	// writing side.  It does make sense on the
	// reading side, because parsing is hard...

	// It is nice to defer check for empty; and
	// potentially for automatic closing tag.
	// Striving for generality can be bad

	// **** GOOD IDEA *****
	// IDEA: separate ArrayList for each open tag.
	//	eg PRIMITIVE, ARRAY
	//	set values by position
	//	add() not needed
	//	clear not needed
	// PROBLEM: not all attributes are needed, eg field
	//	SOLUTION: XMLWriter ignores attributes with a value of null

	// **** GOOD IDEA *****
	// IDEA: have each Attr preassemble what it can, of
	// each name that is: " name='", so this doesn't
	// need to be assembled each time.  XMLWriter then
	// defers to this.

	// IDEA: have each ArrayList pre-assemble *all* the
	// attributes - but little to gain by this. It just
	// shifts the loop, which still must be executed
	// just as often

	// **** GOOD IDEA *****
	// IDEA: writeEmpty(String, attrs); // with attrs
	// EMPTY elements:
	//		reset, primitive, string, reference, null
	// non-EMPTY elements:
	//		jsx, array, object, declaredclass & default

	// IDEA: a writeOpen(String); // with no attrs
	// no attributes:
	//		jsx (as yet), reset, default

	// IDEA: writeEmpty(String); // with *no* attrs
	// EMPTY & no attributes
	//		reset

	ArrayList NOATTRS = new ArrayList();
	ArrayList attrs = new ArrayList();

	public void openGraph(int major, int minor, String format) throws IOException {
		out.openDocument();
		attrs.add( new Attr("major", Integer.toString(major)) );
		attrs.add( new Attr("minor", Integer.toString(minor)) );
		attrs.add( new Attr("format", format) );
		out.writeOpen("jsx", attrs);	// no attrs
		attrs.clear();
	}
	public void closeGraph() throws IOException {
		out.writeClose("jsx");
		out.closeDocument();
	}




	public void _reset() throws IOException {
		out.writeOpen("reset", NOATTRS);	// right way?  - no attrs
		out.writeClose("reset");
	}


/*
	public void primitive(String fieldName, String type, String value) throws IOException {
		if (fieldName!=null) {
			attrs.add(new Attr("field", fieldName));
		}
		attrs.add(new Attr("type", type));
		attrs.add(new Attr("value", value));
		out.writeOpen("primitive", attrs);
		out.writeClose("primitive");		//nice to have a direct "empty element"?
		attrs.clear();
	}
*/

	Attr FIELD = new Attr("field", null);
	Attr TYPE = new Attr("type", null);
	Attr VALUE = new Attr("value", null);

	public void primitive(String fieldName, String type, String value) throws IOException {
		if (fieldName!=null) {
			FIELD.value = fieldName;
			attrs.add(FIELD);
		}
		TYPE.value = type;
		attrs.add(TYPE);
		VALUE.value = value;
		attrs.add(VALUE);
		out.writeOpen("primitive", attrs);
		out.writeClose("primitive");		// more eff to have a direct "empty element"?
		attrs.clear();
	}




	public void _null(String fieldName) throws IOException {
		if (fieldName!=null) {
			FIELD.value = fieldName;
			attrs.add(FIELD);
		}
		out.writeOpen("null", attrs);
		out.writeClose("null");	// FIXME: constants avoid mismatch errors
		attrs.clear();
	}




	public void _class(String fieldName, String className) throws IOException {
		if (fieldName!=null) {
			FIELD.value = fieldName;
			attrs.add(FIELD);
		}
		CLASS.value = className;
		attrs.add(CLASS);	//could cache these, and reuse
		out.writeOpen("class", attrs);	// or Class?
		out.writeClose("class");	// FIXME: constants avoid mismatch errors
		attrs.clear();
	}




	Attr IDREF = new Attr("idref", null);

	public void reference(String fieldName, String idref) throws IOException {
		if (fieldName!=null) {
			FIELD.value = fieldName;
			attrs.add(FIELD);
		}
		IDREF.value = idref;
		attrs.add(IDREF);
		out.writeOpen("reference", attrs);
		out.writeClose("reference");	// FIXME: constants avoid mismatch errors
		attrs.clear();
	}



	Attr ID = new Attr("id", null);

	public void string(String fieldName, String id, String value) throws IOException {
		if (fieldName!=null) {
			FIELD.value = fieldName;
			attrs.add(FIELD);
		}
		if (id!=null) {		// maybe unshared
			ID.value = id;
			attrs.add(ID);
		}
		VALUE.value = value;
		attrs.add(VALUE);
		out.writeOpen("string", attrs);
		out.writeClose("string");		//nice to have a direct "empty element"?
		attrs.clear();
	}



	Attr BASE = new Attr("base", null);
	Attr DIM = new Attr("dim", null);
	Attr LENGTH = new Attr("length", null);

	public void openArray(String fieldName, String id, String base, int dim, int length) throws IOException {
		if (fieldName!=null) {
			FIELD.value = fieldName;
			attrs.add(FIELD);
		}
		ID.value = id;
		attrs.add(ID);
		BASE.value = base;
		attrs.add(BASE); // reuse named "class"?
		DIM.value = Integer.toString(dim);	// convert to String
		attrs.add(DIM);
		LENGTH.value = Integer.toString(length);	// convert to String
		attrs.add(LENGTH);
		out.writeOpen("array", attrs);
		attrs.clear();
	}

	public void closeArray() throws IOException {
		out.writeClose("array");
	}

	public void openCollection(String fieldName, String id, String className) throws IOException {
		if (fieldName!=null) {
			FIELD.value = fieldName;
			attrs.add(FIELD);
		}
		ID.value = id;
		attrs.add(ID);
		CLASS.value = className;
		attrs.add(CLASS);	//could cache these, and reuse
		out.writeOpen("collection", attrs);
		attrs.clear();
	}

	public void closeCollection() throws IOException {
		out.writeClose("collection");
	}


	Attr CLASS = new Attr("class", null);
	Attr SUPERCLASSES = new Attr("superclasses", null);

	public void openObject(String fieldName, String id, String className, String superclasses) throws IOException {
		if (fieldName!=null) {
			FIELD.value = fieldName;
			attrs.add(FIELD);
		}
		ID.value = id;
		attrs.add(ID);
		CLASS.value = className;
		attrs.add(CLASS);	//could cache these, and reuse
		if (superclasses!=null) {	// Externalizable will have no superclasses
			SUPERCLASSES.value = superclasses;
			attrs.add(SUPERCLASSES);
		}
		out.writeOpen("object", attrs);
		attrs.clear();
	}

	public void closeObject() throws IOException {
		out.writeClose("object");
	}




	public void openDeclaredClass(String className) throws IOException {
		CLASS.value = className;
		attrs.add(CLASS);	//could cache these, and reuse
		out.writeOpen("declaredClass", attrs);
		attrs.clear();
	}

	public void closeDeclaredClass() throws IOException {
		out.writeClose("declaredClass");
	}




	public void openDefault() throws IOException {
		out.writeOpen("default", NOATTRS);
	}

	public void closeDefault() throws IOException {
		out.writeClose("default");
	}
}
